﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Remoting.Messaging;
using System.Web;
using Microsoft.Practices.EnterpriseLibrary.Data;
using VeteransAffairs.Registries.BusinessManager;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class EmailLogManager
    {
       // private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;
        static AHOBPRShared _sharedManager;

        public static AHOBPRShared sharedManager
        {
            get
            {
                if (_sharedManager == null)
                    _sharedManager = new AHOBPRShared();

                return _sharedManager;
            }
        }

        public static int LogMail(int id, string eTo, string eCC, string eBCC, string subject, string body, string faliledrecipients, int templateId, bool isRegistrant, string createdBy)
        {
            try
            {
                Database db = DatabaseFactory.CreateDatabase();
                int eId = 0;
                if (isRegistrant)
                {
                    eId = (int)db.ExecuteScalar("[AHOBPR].[SP_RecordEmailLog]",
                                 templateId,
                                 id,
                                 UserId,
                                 eTo,
                                 eCC,
                                 eBCC,
                                 subject,
                                 body,
                                 faliledrecipients,
                                 string.IsNullOrEmpty(createdBy) ? createdBy : "AHOBPR DBA",     //createdby
                                 string.IsNullOrEmpty(createdBy) ? createdBy : "AHOBPR DBA"      //Updatedby
                        );
                }
                else
                {
                    eId = (int)db.ExecuteScalar("[AHOBPR].[SP_RecordEmailLog]",
                                 templateId,
                                 null,
                                 id,
                                 eTo,
                                 eCC,
                                 eBCC,
                                 subject,
                                 body,
                                 faliledrecipients,
                                 "DBA",     //createdby
                                 "DBA"      //Updatedby
                        );
                }

                return eId;
            }
            catch (Exception ex)
            {
                sharedManager.LogErrorMessage("Database Update", "AHOBPREmailLogManager.LogMail", ex.Message);
                return 0;
            }
        }

        private static int UserId
        {
            get
            {                
                return 0;
            }
        }

    }
}
